//
//  Heise_App_ClipsApp.swift
//  Heise App Clips
//
//  Created by Gero Gerber on 01.11.20.
//

import SwiftUI

@main
struct Heise_App_ClipsApp: App {

    var body: some Scene {
        WindowGroup {
            ContentView()
                .onAppear() {
                    // Read from shared UserDefaults
                    guard let sharedUserDefaults = UserDefaults(suiteName: "group.heiseAppClips.appClipMigration") else { return }
                    let numberOfAppClipInvocations = sharedUserDefaults.integer(forKey: "appClipInvocations")
                    print("App Clip was invoked #\(numberOfAppClipInvocations) times")

                    // Read from shared container
                    guard var containerUrl = FileManager.default.containerURL(forSecurityApplicationGroupIdentifier: "group.heiseAppClips.appClipMigration") else { return }
                    containerUrl.appendPathComponent("test")
                    let text = try! String(contentsOf: containerUrl, encoding: .utf8)
                    print(text)
                }
        }
    }
}
